/*
 * Decompiled with CFR 0.152.
 */
package tiled.mapeditor.brush;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.ListIterator;
import tiled.core.MapLayer;
import tiled.core.MultilayerPlane;
import tiled.core.TileLayer;
import tiled.mapeditor.brush.AbstractBrush;
import tiled.mapeditor.brush.Brush;
import tiled.view.MapView;

public class CustomBrush
extends AbstractBrush {
    public CustomBrush(MultilayerPlane mlp) {
        this.addAllLayers(mlp.getLayerVector());
        this.fitBoundsToLayers();
    }

    public CustomBrush(TileLayer tileLayer) {
        this.addLayer(tileLayer);
        this.fitBoundsToLayers();
    }

    @Override
    public void setAffectedLayers(int num) {
    }

    @Override
    public int getAffectedLayers() {
        return this.getTotalLayers();
    }

    @Override
    public Shape getShape() {
        return this.getBounds();
    }

    @Override
    public boolean equals(Brush b) {
        return b instanceof CustomBrush && b == this;
    }

    @Override
    public void startPaint(MultilayerPlane mp, int x, int y, int button, int layer) {
        super.startPaint(mp, x, y, button, layer);
    }

    @Override
    public Rectangle doPaint(int x, int y) throws Exception {
        int layer = this.initLayer;
        int centerx = x - this.bounds.width / 2;
        int centery = y - this.bounds.height / 2;
        super.doPaint(x, y);
        ListIterator<MapLayer> itr = this.getLayers();
        while (itr.hasNext()) {
            TileLayer tm;
            TileLayer tl = (TileLayer)itr.next();
            if ((tm = (TileLayer)this.affectedMp.getLayer(layer++)) == null || !tm.isVisible()) continue;
            tl.setOffset(centerx, centery);
            tl.mergeOnto(tm);
        }
        return new Rectangle(centerx, centery, this.bounds.width, this.bounds.height);
    }

    @Override
    public void drawPreview(Graphics2D g2d, MapView mv) {
        mv.paintSubMap(this, g2d, 0.5f);
    }
}

